/*
  Bot AI for Bombing run.
  
  Author Mark Caldwell aka W@rHe@d of The Reliquary
 */
class UTBRTeamAI extends UTTeamAI;

var UTBRBall TheBall;
var UTBRGoal FriendlyGoal, EnemyGoal;


function UTGameObjective GetPriorityAttackObjectiveFor(UTSquadAI InAttackSquad, Controller InController)
{
    return UTBRGame(WorldInfo.Game).Goals[1 - Team.TeamIndex];
}

function UTGameObjective GetLeastDefendedObjective(Controller InController)
{
    return UTBRGame(WorldInfo.Game).Goals[Team.TeamIndex];
}

function UTSquadAI AddSquadWithLeader(Controller C, UTGameObjective O)
{
	local UTBRSquadAI S;
	
	if ( O == None )
		O = TheBall.HomeBase;
	S = UTBRSquadAI(Super.AddSquadWithLeader(C,O));
	if ( S != None )
	{
		S.FriendlyGoal = FriendlyGoal;
		S.EnemyGoal = EnemyGoal;
		S.TheBall = TheBall;
        S.Init();		
	}

		
	return S;
}

function UTGameObjective GetPriorityFreelanceObjectiveFor(UTSquadAI InFreelanceSquad)
{
	if (InFreelanceSquad != None)
	{
		InFreelanceSquad.bFreelanceAttack = true;
	}
	return GetPriorityAttackObjectiveFor(InFreelanceSquad, (InFreelanceSquad != None) ? InFreelanceSquad.SquadLeader : None);
}

defaultproperties
{
   SquadType=Class'BombingRun.UTBRSquadAI'
   OrderList(0)="ATTACK"
   OrderList(1)="Defend"
   OrderList(2)="ATTACK"
   OrderList(4)="ATTACK"
   OrderList(5)="Defend"
   OrderList(6)="ATTACK"
   OrderList(7)="ATTACK"
   Name="Default__UTBRTeamAI"
   ObjectArchetype=UTTeamAI'UTGame.Default__UTTeamAI'
}
